<?php
    use App\Models\Utility;
    $logo = asset('storage/uploads/logo');

    $setting = Utility::colorset();


    $mode_setting = Utility::mode_layout();


    $company_logo = Utility::get_company_logo();
    $company_logos = Utility::getValByName('company_logo_light');
    $settings = Utility::settings();
?>

<?php $__env->startSection('title-content'); ?>
    <h2 class="text-center p-0 m-5 " style="color: #fff"><?php echo e(__('Create Ticket')); ?></h2>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('nav-content'); ?>
    <nav class="navbar navbar-expand-md navbar-dark default dark_background_color">
        <div class="container-fluid pe-2">

            <a class="navbar-brand" href="<?php echo e(route('user.ticket.create')); ?>">
                <?php if($mode_setting['cust_darklayout'] && $mode_setting['cust_darklayout'] == 'on'): ?>
                    <img src="<?php echo e($logo . '/' . (isset($company_logos) && !empty($company_logos) ? $company_logos : 'logo-dark.png') . '?' . time()); ?>"
                        alt="<?php echo e(config('app.name', 'Smart Chamber-SaaS')); ?>" class="logo "
                        style="height: 30px; width: 180px;">
                <?php else: ?>
                    <img src="<?php echo e($logo . '/' . (isset($company_logo) && !empty($company_logo) ? $company_logo : 'logo-dark.png') . '?' . time()); ?>"
                        alt="<?php echo e(config('app.name', 'Smart Chamber-SaaS')); ?>" class="logo "
                        style="height: 30px; width: 180px;">
                <?php endif; ?>
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarTogglerDemo01"
                aria-controls="navbarTogglerDemo01" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarTogglerDemo01" style="flex-grow: 0;">
                <ul class="navbar-nav align-items-center ms-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                    <li class="nav-item ">
                        <a class="nav-link" href="#"><?php echo e(__('Create Ticket')); ?></a>
                    </li>
                    <li class="nav-item ">
                        <a class="nav-link" href="<?php echo e(route('user.ticket.search')); ?>"><?php echo e(__('Search Ticket')); ?></a>
                    </li>

                    <li class="nav-item">
                        <a href="<?php echo e(route('user.faq')); ?>" class="nav-link"><?php echo e(__('FAQ')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('user.knowledge')); ?>"><?php echo e(__('Knowledge')); ?></a>
                    </li>
                    </li>
                </ul>
            </div>

        </div>
    </nav>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-xl-12 text-center">
        <div class="mx-3 mx-md-5 mt-3">

        </div>

        <?php if(Session::has('create_ticket')): ?>
            <div class="alert alert-success">
                <p><?php echo session('create_ticket'); ?></p>
            </div>
        <?php endif; ?>

        <div class="card rounded-0 ">
            <div class="card-body w-100">

                <form method="post" action="<?php echo e(route('home.store')); ?>" class="create-form" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="text-start row">
                        <?php if(!$customFields->isEmpty()): ?>
                            <?php echo $__env->make('customFields.formBuilder', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>

                        <?php if($settings['recaptcha_module'] == 'on'): ?>
                            <div class="form-group mb-3">
                                <?php echo NoCaptcha::display(); ?>

                                <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="small text-danger" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>
                        <div class="text-center">
                            <div class="d-block ">
                                <input type="hidden" name="status" value="New Ticket" />
                                <button class="btn btn-primary btn-block mt-2">
                                    <?php echo e(__('Create Ticket')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.custom_guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcms/public_html/resources/views/userTicket/index.blade.php ENDPATH**/ ?>