<?php $__env->startSection('page-title', __('Advocate')); ?>

<?php $__env->startSection('action-button'); ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create advocate')): ?>
        <div class="text-sm-end d-flex all-button-box justify-content-sm-end">
            <a href="<?php echo e(route('advocates.export')); ?>" class="btn btn-sm btn-primary mx-1" data-bs-toggle="tooltip"
                data-title=" <?php echo e(__('Export')); ?>" title="<?php echo e(__('Export')); ?>">
                <i class="ti ti-file-export"></i>
            </a>
            <a href="<?php echo e(route('advocate.create')); ?>" class="btn btn-sm btn-primary mx-1" data-toggle="tooltip"
                title="<?php echo e(__('Add New Advocate')); ?>" data-bs-toggle="tooltip" data-bs-placement="top">
                <i class="ti ti-plus"></i>
            </a>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><?php echo e(__('Advocate')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row p-0">
        <div class="col-xl-12">

            <div class="card-header card-body table-border-style">
                <h5></h5>
                <div class="table-responsive">
                    <table class="table dataTable data-table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('#')); ?></th>
                                <th><?php echo e(__('Advocate Name')); ?></th>
                                <th><?php echo e(__('Company Name')); ?></th>
                                <th><?php echo e(__('Email')); ?></th>
                                <th><?php echo e(__('Contact')); ?></th>
                                <th width="100px" class="text-center"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php $__currentLoopData = $advocates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $advocate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>
                                    <td>
                                        <?php echo e($key + 1); ?>

                                    </td>
                                    <td><?php echo e($advocate->getAdvUser->name); ?></td>
                                    <td><?php echo e($advocate->company_name); ?></td>
                                    <td><?php echo e($advocate->getAdvUser->email); ?></td>
                                    <td><?php echo e($advocate->phone_number); ?></td>
                                    <td>
                                        <?php if($advocate->getAdvUser->is_disable == 0 ): ?>

                                            <i class="ti ti-lock"></i>
                                        <?php else: ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view advocate')): ?>
                                                <div class="action-btn bg-light-secondary ms-2">
                                                    <a href="#" class="mx-3 btn btn-sm d-inline-flex align-items-center "
                                                        data-url="<?php echo e(route('advocate.show', $advocate->id)); ?>" data-size="xl"
                                                        data-ajax-popup="true"
                                                        data-title="<?php echo e($advocate->getAdvUser->name); ?><?php echo e(__("'s Cases")); ?>"
                                                        title="<?php echo e(__('View Case')); ?>" data-bs-toggle="tooltip"
                                                        data-bs-placement="top">
                                                        <i class="ti ti-clipboard-list "></i>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit advocate')): ?>
                                                <div class="action-btn bg-light-secondary ms-2">
                                                    <a href="<?php echo e(route('advocate.edit', $advocate->id)); ?>"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center "
                                                        title="<?php echo e(__('Edit')); ?>" data-bs-toggle="tooltip"
                                                        data-bs-placement="top"><i class="ti ti-edit "></i></a>
                                                </div>
                                            <?php endif; ?>

                                            <?php if(Auth::user()->type == 'company'): ?>
                                                <div class="action-btn bg-light-secondary ms-2">
                                                    <a href="#"
                                                        data-url="<?php echo e(route('company.reset', \Crypt::encrypt($advocate->user_id))); ?>"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center "
                                                        data-tooltip="Edit" data-ajax-popup="true"
                                                        data-title="<?php echo e(__('Reset Password')); ?>" data-bs-toggle="tooltip"
                                                        data-bs-placement="top" title="<?php echo e(__('Reset Password')); ?>">

                                                        <i class="ti ti-key "></i>

                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view advocate')): ?>
                                                <div class="action-btn bg-light-secondary ms-2">
                                                    <a href="#" class="mx-3 btn btn-sm d-inline-flex align-items-center "
                                                        data-url="<?php echo e(route('advocate.view', $advocate->id)); ?>" data-size="lg"
                                                        data-ajax-popup="true"
                                                        data-title="<?php echo e($advocate->getAdvUser->name); ?>"
                                                        title="<?php echo e(__('View')); ?>" data-bs-toggle="tooltip"
                                                        data-bs-placement="top">
                                                        <i class=" ti ti-eye "></i>
                                                    </a>
                                                </div>
                                            <?php endif; ?>


                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete advocate')): ?>
                                                <div class="action-btn bg-light-secondary ms-2">
                                                    <a href="#"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center bs-pass-para"
                                                        data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                        data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                        data-confirm-yes="delete-form-<?php echo e($advocate->id); ?>"
                                                        title="<?php echo e(__('Delete')); ?>" data-bs-toggle="tooltip"
                                                        data-bs-placement="top">
                                                        <i class="ti ti-trash"></i>
                                                    </a>
                                                </div>
                                            <?php endif; ?>

                                            <?php echo Form::open([
                                                'method' => 'DELETE',
                                                'route' => ['advocate.destroy', $advocate->id],
                                                'id' => 'delete-form-' . $advocate->id,
                                            ]); ?>

                                            <?php echo Form::close(); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcms/public_html/resources/views/advocate/index.blade.php ENDPATH**/ ?>