<?php $__env->startSection('page-title', __('Client')); ?>


<?php $__env->startSection('action-button'); ?>
<div class="row align-items-center mb-3">
    <div class="col-md-12 d-flex align-items-center  justify-content-end">
        <div class="text-end d-flex all-button-box justify-content-md-end justify-content-center">
            <a href="<?php echo e(route('client.list')); ?>" class="btn btn-sm btn-primary mx-1" data-ajax-popup="true"
                data-size="md" data-title="Add Client" data-toggle="tooltip" title="<?php echo e(__('List View')); ?>" data-bs-original-title="<?php echo e(__('List View')); ?>" data-bs-placement="top" data-bs-toggle="tooltip">
                <i class="ti ti-menu-2"></i>
            </a>
        </div>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['create member','create user'])): ?>
        <div class="text-end d-flex all-button-box justify-content-md-end justify-content-center">
            <a href="#" class="btn btn-sm btn-primary mx-1" data-ajax-popup="true" data-size="md"
                data-title="Add Client" data-url="<?php echo e(route('client.create')); ?>" data-toggle="tooltip"
                title="<?php echo e(__('Create New Client')); ?>">
                <i class="ti ti-plus"></i>
            </a>
        </div>
    </div>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>

    <li class="breadcrumb-item"><?php echo e(__('Client')); ?></li>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="row g-0 pt-0">
    <div class="col-xxl-12">
        <div class="row g-0">
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-xxl-3 col-lg-4 col-sm-6 border-end border-bottom">
                    <div class="card  shadow-none bg-transparent border h-100 text-center rounded-0">
                        <div class="card-header border-0 pb-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">
                                    <?php if(\Auth::user()->type == "super admin"): ?>
                                        <div class="">
                                            <a href="#" class="btn btn-sm btn-light-primary text-sm" data-url="<?php echo e(route('plan.upgrade',$user->id)); ?>"
                                                data-size="lg" data-ajax-popup="true" data-title="<?php echo e(__('Upgrade Plan')); ?>">
                                                <?php echo e(__('Upgrade Plan')); ?>

                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div class="badge p-2 px-3 rounded bg-primary"><?php echo e(ucfirst($user->type)); ?></div>
                                    <?php endif; ?>
                                </h6>
                            </div>

                            <?php if(Gate::check('delete member') || Gate::check('delete user')): ?>
                            <div class="card-header-right">
                                <div class="btn-group card-option">

                                    <?php if(Auth::user()->type == 'super admin'): ?>
                                        <button type="button" class="btn dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <div class="dropdown-menu dropdown-menu-end">

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit member','edit user'])): ?>
                                            <a href="<?php echo e(route('users.edit', $user->id)); ?>" class="dropdown-item" data-bs-original-title="<?php echo e(__('Edit User')); ?>">
                                                <i class="ti ti-pencil"></i>
                                                <span><?php echo e(__('Edit')); ?></span>
                                            </a>
                                            <?php endif; ?>

                                            <a href="#!" data-url="<?php echo e(route('company.reset',\Crypt::encrypt($user->id))); ?>" data-ajax-popup="true" data-size="md"
                                                class="dropdown-item" data-bs-original-title="<?php echo e(__('Reset Password')); ?>" data-title="<?php echo e(__('Reset Password')); ?>"
                                                title="<?php echo e(__('Reset Password')); ?>">
                                                <i class="ti ti-adjustments"></i>
                                                <span> <?php echo e(__('Reset Password')); ?></span>
                                            </a>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['delete member','delete user'])): ?>
                                            <?php echo Form::open([
                                            'method' => 'DELETE',
                                            'route' => ['users.destroy', $user->id],
                                            'id' => 'delete-form-' . $user->id,
                                            ]); ?>

                                            <a href="#" class="dropdown-item bs-pass-para" data-id="<?php echo e($user['id']); ?>" data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                data-confirm-yes="delete-form-<?php echo e($user->id); ?>" title="<?php echo e(__('Delete')); ?>" data-bs-toggle="tooltip"
                                                data-bs-placement="top">
                                                <i class="ti ti-archive"></i>
                                                <span> <?php echo e(__('Delete')); ?></span>
                                            </a>
                                            <?php echo Form::close(); ?>

                                            <?php endif; ?>


                                        </div>

                                    <?php else: ?>
                                        <?php if($user->is_active == 1 && $user->is_disable == 1): ?>
                                            <button type="button" class="btn dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="ti ti-dots-vertical"></i>
                                            </button>

                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a data-url="<?php echo e(route('users.show', $user->id)); ?>" href="#" class="dropdown-item" data-ajax-popup="true"  data-size="md"
                                                data-title="<?php echo e($user->name . __("'s Group")); ?>">
                                                    <i class="ti ti-eye"></i>
                                                    <span><?php echo e(__('View Groups')); ?></span>
                                                </a>

                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit member','edit user'])): ?>
                                                <a href="<?php echo e(route('users.edit', $user->id)); ?>" class="dropdown-item" data-bs-original-title="<?php echo e(__('Edit User')); ?>">
                                                    <i class="ti ti-pencil"></i>
                                                    <span><?php echo e(__('Edit')); ?></span>
                                                </a>
                                                <?php endif; ?>

                                                <a href="#!" data-url="<?php echo e(route('company.reset',\Crypt::encrypt($user->id))); ?>" data-ajax-popup="true" data-size="md"
                                                    class="dropdown-item" data-bs-original-title="<?php echo e(__('Reset Password')); ?>" data-title="<?php echo e(__('Reset Password')); ?>"
                                                    title="<?php echo e(__('Reset Password')); ?>">
                                                    <i class="ti ti-adjustments"></i>
                                                    <span> <?php echo e(__('Reset Password')); ?></span>
                                                </a>

                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['delete member','delete user'])): ?>
                                                <?php echo Form::open([
                                                'method' => 'DELETE',
                                                'route' => ['users.destroy', $user->id],
                                                'id' => 'delete-form-' . $user->id,
                                                ]); ?>

                                                <a href="#" class="dropdown-item bs-pass-para" data-id="<?php echo e($user['id']); ?>" data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                    data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                    data-confirm-yes="delete-form-<?php echo e($user->id); ?>" title="<?php echo e(__('Delete')); ?>" data-bs-toggle="tooltip"
                                                    data-bs-placement="top">
                                                    <i class="ti ti-archive"></i>
                                                    <span> <?php echo e(__('Delete')); ?></span>
                                                </a>
                                                <?php echo Form::close(); ?>

                                                <?php endif; ?>


                                            </div>
                                        <?php else: ?>
                                            <a href="#" class="action-item"><i class="ti ti-lock"></i></a>
                                        <?php endif; ?>
                                    <?php endif; ?>


                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        <a href="<?php echo e(route('client.show',[$user->id])); ?>">
                            <div class="card-body full-card">
                                <div class="img-fluid rounded-circle card-avatar">
                                    <img src="<?php echo e((!empty($user->avatar))? asset("storage/uploads/profile/".$user->avatar):
                                    asset("storage/uploads/profile/avatar.png")); ?>" class="img-user wid-80 round-img
                                    rounded-circle">
                                </div>
                                <h4 class=" mt-3 text-primary"><?php echo e($user->name); ?></h4>

                                <small class="text-primary"><?php echo e($user->email); ?></small>
                                <p></p>
                                <div class="text-center" data-bs-toggle="tooltip" title="<?php echo e(__('Last Login')); ?>">
                                    <?php echo e((!empty($user->last_login_at)) ? $user->last_login_at : ''); ?>

                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6 col-xxl-3 col-lg-4 col-sm-6 border-end border-bottom">
                <div class="card  shadow-none bg-transparent border h-100 text-center rounded-0">
                    <div class="card-body border-0 pb-0">
                        <a href="#" class="btn-addnew-project border-0" data-ajax-popup="true" data-size="md" data-title="Create New User"
                            data-url="<?php echo e(route('client.create')); ?>">
                                <div class="bg-primary proj-add-icon">
                                    <i class="ti ti-plus"></i>
                                </div>
                            <h6 class="mt-4 mb-2"><?php echo e(__('New User')); ?></h6>
                            <p class="text-muted text-center"><?php echo e(__('Click here to add New User')); ?></p>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcms/public_html/resources/views/client/index.blade.php ENDPATH**/ ?>