<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash; // Added missing import
use Illuminate\Support\Facades\Validator;
use App\Models\UserDetail;
use Illuminate\Support\Facades\Auth;


class UserController extends Controller
{
      public function getCompanies(Request $request)
    {
        // Fetch users where the type is 'company'
        $companies = User::where('type', 'company')->get(['id', 'name']);
        
        // Return response in JSON format
        return response()->json([
            'status' => 'success',
            'data' => $companies
        ]);
    }

  public function storeclinet(Request $request)
{
    // Validate the input fields
    $validator = Validator::make($request->all(), [
        'name'       => 'required|max:120',
        'email'      => 'nullable|email|unique:users',
        'password'   => 'required',
        'company_id' => 'required|exists:users,id',
    ]);

    // If validation fails, return error
    if ($validator->fails()) {
        return response()->json([
            'success' => false,
            'message' => $validator->getMessageBag()->first()
        ]);
    }

    // Register the client user
    $user = new User();
    $user->name              = $request->name;
    $user->email             = $request->email;
    $user->password          = Hash::make($request->password); // Hash the password
    $user->lang              = 'en';
    $user->created_by        = $request->company_id;           // from request
    $user->email_verified_at = now();
    $user->type              = 'client';                       // user type
    $user->assignRole('client');
    $user->save();

    // Create user detail entry
    $detail         = new UserDetail();
    $detail->user_id = $user->id;
    $detail->save();

    // Return success JSON with the new message
    return response()->json([
        'success' => true,
        'message' => 'Switched to PM successfully.',
        'data'    => $user
    ]);
}


}
